public class MonteCarloIntegration {
	public static double circularIntegral() {
		int nIter= 1000000;
		double sum= 0.0, radius= 0.5;
		for (int i=0; i < nIter; i++) {
			// Math.random() returns double d: 0 <= d <= 1
			double x= Math.random() - radius;  // Ctr at 0,0
			double y= Math.random() - radius;
			double f= 1.0;		// f(x,y)constant here
			if ((x*x + y*y) < radius*radius) // If in region
				sum += f;		// Increment integral sum
		}
		return sum/nIter;	// Integral value
	}    
	
	public static void main(String[] args) {
		System.out.println("Result: " +circularIntegral() );
		System.out.println("Pi: "+ 4.0*circularIntegral() );
	}   
}